import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the grid dimensions
rows, cols = 5, 4
tile_size = 1

# Create a figure and axis
fig, ax = plt.subplots(figsize=(cols * tile_size, rows * tile_size))

# Define colors
clear_color = 'green'
occupied_color = 'yellow'
white_color = 'white'
black_color = 'black'
painted_color = 'red'

# Draw the grid of tiles
for i in range(rows):
    for j in range(cols):
        # Determine status
        if (i == 1 and j == 0):
            tile_color = occupied_color
            label = 'tile_1-1\nRobot1\nWhite'
        elif (i == 1 and j == 1):
            tile_color = occupied_color
            label = 'tile_1-2\nRobot2\nBlack'
        else:
            tile_color = clear_color
            label = f'tile_{i}-{j+1}\nClear'
        
        # Add a rectangle for each tile
        ax.add_patch(patches.Rectangle((j, rows - i - 1), tile_size, tile_size, edgecolor='black', facecolor=tile_color))
        # Add text label
        ax.text(j + 0.5, rows - i - 0.5, label, fontsize=8, ha='center', va='center', color='black' if tile_color != black_color else 'white')

# Draw robots
ax.add_patch(patches.Circle((0.5, rows - 1.5), 0.3, color=white_color, ec='black'))
ax.add_patch(patches.Circle((1.5, rows - 1.5), 0.3, color=black_color, ec='black'))

# Draw available colors
ax.add_patch(patches.Rectangle((cols + 0.5, rows - 1), 0.5, 0.5, edgecolor='black', facecolor=white_color))
ax.text(cols + 0.75, rows - 0.75, 'White', fontsize=8, ha='center', va='center', color='black')
ax.add_patch(patches.Rectangle((cols + 0.5, rows - 1.5), 0.5, 0.5, edgecolor='black', facecolor=black_color))
ax.text(cols + 0.75, rows - 1.25, 'Black', fontsize=8, ha='center', va='center', color='white')

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='Robot with White'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Robot with Black'),
    patches.Patch(facecolor=painted_color, edgecolor='black', label='Painted Tile')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.5, 1))

# Set limits and remove axes
ax.set_xlim(0, cols + 2)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_43.png', bbox_inches='tight')
plt.close(fig)
# VERIFICATION FAILED:
# Legend overlaps with the grid, making some tiles less visible.
